## which is non-standard. Use builtin 'command -v' instead.

### Problematic code:

```sh
which grep
```

### Correct code:

```sh
command -v grep
```

### Rationale:

`which` is a non-standard, external tool that locates an executable in PATH. `command -v` is a POSIX standard builtin, which uses the same lookup mechanism that the shell itself would.

### Exceptions:

None

### Caveats:

With BASH 5.0.7 (via homebrew on macOS 10.13.6), `command -v` appears to take multiple parameters:

```
# grep is in /usr/bin/grep
# foobar is not in path
#
$ command -v -- grep foobar; echo $?
0
```

but succeeds (with exit code 0) if *any* command exists. In the above
example, it should have failed and exited with 1 unless *all* commands
exist.

An alternative is:

```
$ hash <file1> <file2>
```

Which observes the standard behaviour of failures.

### Related resources:

* [Check if a program exists from a Bash script](https://stackoverflow.com/a/677212/1899640) on StackOverflow.
[Source](https://github.com/koalaman/shellcheck/wiki/SC2230)

