
Shared naming conventions allow teams to collaborate efficiently. This rule checks whether or not method and property names are PascalCased. To<br>reduce noise, two consecutive upper case characters are allowed unless they form the whole name. So, `MyXMethod` is compliant, but<br>`XM` on its own is not.

## Noncompliant Code Example


    public int doSomething() {...}


## Compliant Solution


    public int DoSomething() {...}


## Exceptions

- The rule ignores members in types that are marked with `ComImportAttribute` or `InterfaceTypeAttribute`.
- The rule ignores `extern` methods.
- The rule allows for two-letter acronyms in which both letters are capitalized, as shown in the following identifier:<br>  `ExecuteOnUIThread`.
- Furthermore, when `'_'` character is found in a name, the camel casing is not enforced.



    void My_method(){...} // valid
    void My_method_(){...} // invalid, leading and trailing underscores are reported


## See

[Microsoft Capitalization<br>Conventions](https://docs.microsoft.com/en-us/dotnet/standard/design-guidelines/capitalization-conventions)
