
Declaring multiple variable on one line is difficult to read.

## Noncompliant Code Example


    class MyClass
    {
      private int a, b; // Noncompliant
    
      public void Method()
      {
        int c, d; // Noncompliant
      }
    }


## Compliant Solution


    class MyClass
    {
      private int a;
      private int b;
    
      public void Method()
      {
        int c;
        int d;
      }
    }


## See

- [CERT, DCL52-J.](https://www.securecoding.cert.org/confluence/x/7wHEAw) - Do not declare more than one variable per declaration<br>
- [CERT, DCL04-C.](https://www.securecoding.cert.org/confluence/x/VgU) - Do not declare more than one variable per declaration

