
Caller information attributes: `CallerFilePathAttribute` and `CallerLineNumberAttribute` provide a way to get information<br>about the caller of a method through optional parameters. But the arguments for these optional parameters are only generated if they are not<br>explicitly defined in the call. Thus, specifying the argument values defeats the purpose of the attributes.

## Noncompliant Code Example


    void TraceMessage(string message,
      [CallerFilePath] string filePath = null,
      [CallerLineNumber] int lineNumber = 0)
    {
      /* ... */
    }
    
    void MyMethod()
    {
      TraceMessage("my message", "A.B.C.Foo.cs", 42); // Noncompliant
    }


## Compliant Solution


    void TraceMessage(string message,
      [CallerFilePath] string filePath = "",
      [CallerLineNumber] int lineNumber = 0)
    {
      /* ... */
    }
    
    void MyMethod()
    {
      TraceMessage("my message");
    }


## Exceptions

`CallerMemberName` is not checked to avoid False-Positives with WPF/UWP applications.
