
Not surprisingly, the `SafeHandle.DangerousGetHandle` method is dangerous. That's because it may not return a valid handle. Using it can<br>lead to leaks and vulnerabilities. While it is possible to use the method successfully, it's extremely difficult to do correctly, so the method should<br>simply be avoided altogether.

## Noncompliant Code Example


    static void Main(string[] args)
    {
        System.Reflection.FieldInfo fieldInfo = ...;
        SafeHandle handle = (SafeHandle)fieldInfo.GetValue(rKey);
        IntPtr dangerousHandle = handle.DangerousGetHandle();  // Noncompliant
    }

