
String representations of URIs or URLs are prone to parsing and encoding errors which can lead to vulnerabilities. The `System.Uri`<br>class is a safe alternative and should be preferred.

This rule raises an issue when a method has a `string` return type and its name contains "Uri", "Urn", or "Url" or begins with "uri",<br>"urn", or "url".

## Noncompliant Code Example


    using System;
    
    namespace MyLibrary
    {
       public class MyClass
       {
          public string GetParentUri() // Noncompliant
          {
             return "http://www.mysite.com";
          }
       }
    }


## Compliant Solution


    using System;
    
    namespace MyLibrary
    {
       public class MyClass
       {
    
          public Uri GetParentUri()
          {
             return new URI("http://www.mysite.com");
          }
       }
    }

