
Private fields only used to store values without reading them later is a case of dead store. So changing the value of such field is useless and<br>most probably indicates a serious error in the code.

## Noncompliant Code Example


    public class Rectangle
    {
      private readonly int length;
      private readonly int width;  // width is written but never read
    
      public Rectangle(int length, int width)
      {
        this.length = length;
        this.width = width;
      }
    
      public int Surface
      {
        get
        {
          return length * length;
        }
      }
    }


## Compliant Solution


    public class Rectangle
    {
      private readonly int length;
      private readonly int width;
    
      public Rectangle(int length, int width)
      {
        this.length = length;
        this.width= width;
      }
    
      public int Surface
      {
        get
        {
          return length * width;
        }
      }
    }


## See

- [MITRE, CWE-563](http://cwe.mitre.org/data/definitions/563.html) - Assignment to Variable without Use ('Unused Variable')
- [CERT, MSC13-C.](https://www.securecoding.cert.org/confluence/x/QYA5) - Detect and remove unused values
- [CERT, MSC56-J.](https://www.securecoding.cert.org/confluence/x/uQCSBg) - Detect and remove superfluous code and values

