
When the syntax `new Guid()` (i.e. parameterless instantiation) is used, it must be that one of three things is wanted:

1. An empty GUID, in which case `Guid.Empty` is clearer.
2. A randomly-generated GUID, in which case `Guid.NewGuid()` should be used.
3. A new GUID with a specific initialization, in which case the initialization parameter is missing.


This rule raises an issue when a parameterless instantiation of the `Guid` struct is found.

## Noncompliant Code Example


    public void Foo()
    {
        var g = new Guid(); // Noncompliant - what's the intent?
    }


## Compliant Solution


    public void Foo(byte[] bytes)
    {
        var g1 = Guid.Empty;
        var g2 = Guid.NewGuid();
        var g3 = new Guid(bytes);
    }

