**B107: Test for use of hard-coded password argument defaults**

The use of hard-coded passwords increases the possibility of password
guessing tremendously. This plugin test looks for all function
definitions that specify a default string literal for some argument. It
checks that the argument does not look like a password.

Variables are considered to look like a password if they have match any
one of:

-   "password"

-   "pass"

-   "passwd"

-   "pwd"

-   "secret"

-   "token"

-   "secrete"

Note: this can be noisy and may generate false positives.

**Config Options:**

None

Example

:   

<!-- -->

    >> Issue: [B107:hardcoded_password_default] Possible hardcoded
    password: 'Admin'
       Severity: Low   Confidence: Medium
       Location: ./examples/hardcoded-passwords.py:1

    1    def someFunction(user, password="Admin"):
    2      print("Hi " + user)

See also

-   <https://www.owasp.org/index.php/Use_of_hard-coded_password>

New in version 0.9.0.
