## Last user should not be root.

### Problematic code:

```dockerfile
FROM busybox
USER root
RUN ...
```

### Correct code:

```dockerfile
FROM busybox
USER root
RUN ...
USER guest
```
### Rationale:

Switching to the root `USER` opens up certain security risks if an attacker gets access to the container. In order to mitigate this, switch back to a non privileged user after running the commands you need as root.