## Pin versions in `npm`.

### Problematic code:

```dockerfile
FROM node:8.9.1

RUN npm install express
RUN npm install @myorg/privatepackage
RUN npm install express sax@0.1.1
RUN npm install --global express
RUN npm install git+ssh://git@github.com:npm/npm.git
RUN npm install git+http://isaacs@github.com/npm/npm
RUN npm install git+https://isaacs@github.com/npm/npm.git
RUN npm install git://github.com/npm/npm.git
```

### Correct code:

```dockerfile
FROM node:8.9.1

RUN npm install express@4.1.1
RUN npm install @myorg/privatepackage@">=0.1.0"
RUN npm install express@"4.1.1" sax@0.1.1
RUN npm install --global express@"4.1.1"
RUN npm install git+ssh://git@github.com:npm/npm.git#v1.0.27
RUN npm install git+http://isaacs@github.com/npm/npm#semver:^5.0
RUN npm install git+https://isaacs@github.com/npm/npm.git#v1.0.27
RUN npm install git://github.com/npm/npm.git#v1.0.27
```
### Rationale:

Version pinning forces the build to retrieve a particular version regardless of what’s in the cache. This technique can also reduce failures due to unanticipated changes in required packages.
>https://docs.docker.com/engine/articles/dockerfile_best-practices/

### Exceptions:

Pin your versions in `package.json` and run `npm install` with no arguments.