# Don't put spaces around the = in assignments.

### Problematic code:

```sh
foo = 42
```

### Correct code:

```sh
foo=42
```

### Rationale:

Shells are space sensitive. `foo=42` means to assign `42` to the variable `foo`. `foo = 42` means to run a command named `foo`, and pass `=` as `$1` and `42` as `$2`.

### Exceptions

If you actually wanted to run a command named foo and provide `=` as the first argument, simply quote it to make ShellCheck be quiet: `foo "=" 42`.
