//#Patterns: Custom_Scala_PlayUntrustedHttpRequestParameter
package controllers

import play.api.mvc._
import play.api.libs.json._

import scala.concurrent.Future

class Application extends Controller {

  //fine
  def index = Action {
    val list = List(1, 2, 3)
    Ok(Json.toJson(list))
  }

  //#Warn: Custom_Scala_PlayUntrustedHttpRequestParameter
  def index2(string: String): Action[AnyContent] = ???

  //#Warn: Custom_Scala_PlayUntrustedHttpRequestParameter
  def index2(string: String) = Action {
    Ok(Json.toJson(string))
  }

  //#Warn: Custom_Scala_PlayUntrustedHttpRequestParameter
  def index3(string:String,int:Int) = Action(parse.json){ req =>
    Ok("Hello, World!")
  }

  //#Warn: Custom_Scala_PlayUntrustedHttpRequestParameter
  def index4(string:String)(otherParamL:Int) = Action{ req =>
    Ok("Hello, World!")
  }

  //#Warn: Custom_Scala_PlayUntrustedHttpRequestParameter
  def index5(string:String)(implicit otherParamL:Int) = {
    Action{ req =>
      Ok("Hello, World!")
    }
  }

  //#Warn: Custom_Scala_PlayUntrustedHttpRequestParameter
  def index5(string:String) = Action.async(parse.json[String]){ req =>
    Future.successful(Ok("Hello, World!"))
  }

  //fine
  def index6() = Action.async(parse.json[String]){ req =>
    Future.successful(Ok("Hello, World!"))
  }


}