## This is a Unicode single quote. Delete and retype it.

### Problematic code:

```sh
echo ‘hello world’
```

### Correct code:

```sh
echo 'hello world'
```

### Rationale:

Some software, like OS X, Word and WordPress, may automatically replace your regular quotes with slanted Unicode quotes. Try deleting and retyping them, and/or disable “smart quotes” in your editor or OS.

### Status:

This error was retired after 0.4.5. In this version and earlier, ShellCheck parsed slanted quotes as a valid double quote. This meant that the warning could not simply be ignored. It has since been replaced by [[SC1110]] (outside quotes) and [[SC1112]] (inside single quotes).


### Exceptions

If you want to use typographic single quotes, you can put them in double quotes (or typographic double quotes in single quotes) to make shellcheck ignore them, e.g.,

```sh
printf "Warning: ‘wakeonlan’ is not installed.\n"
```
[Source](https://github.com/koalaman/shellcheck/wiki/SC1016)

