## Expected this to be an argument to the unary condition.

### Problematic code:

```sh
[ -x ]
```

### Correct code:

```sh
[ -x "myfile" ]
```
### Rationale:

ShellCheck has found a unary test operator that does not appear to be followed by a valid shell word. 

This could be because of a misplaced `]`, `)`, or a missing space before the `]`.

Check the syntax, make sure the test operator has an operand, and try again.

### Exceptions:

None.

### Related resources:

* Help by adding links to BashFAQ, StackOverflow, man pages, POSIX, etc!
[Source](https://github.com/koalaman/shellcheck/wiki/SC1019)

