## In [..] you have to escape \\( \\) or preferably combine [..] expressions.

### Problematic code:

```sh
[ -e ~/.bashrc -a ( -x /bin/dash -o -x /bin/ash ) ]
```

### Correct code:

In POSIX:
```sh
[ -e ~/.bashrc ] &&  { [ -x /bin/dash ] || [ -x /bin/ash ]; }
```

Obsolete XSI syntax:
```sh
[ -e ~/.bashrc -a \( -x /bin/dash -o -x /bin/ash \) ]
```

### Rationale:

`[` is implemented as a regular command, so `(` is not special.

The preferred way is not to group inside `[ .. ]` and instead compose multiple `[ .. ]` statments using the shell's `&&`, `||` and `{ ..; }` syntax, since this is well defined by POSIX.

Some shells, such as Bash, support grouping with `\( .. \)`, but this is an obsolete XSI-only extension.

### Exceptions:

None
[Source](https://github.com/koalaman/shellcheck/wiki/SC1028)

