## In `[[..]]` you shouldn't escape `(` or `)`.

### Problematic code:

```sh
[[ -e ~/.bashrc -a \( -x /bin/dash -o -x /bin/ash \) ]]
```

### Correct code:

```sh
[[ -e ~/.bashrc -a ( -x /bin/dash -o -x /bin/ash ) ]]
```

### Rationale:

You don't have to -- and can't -- escape `(` or `)` inside a `[[ .. ]]` expression like you do in `[ .. ]`. Just remove the escaping.

### Exceptions:

None.
[Source](https://github.com/koalaman/shellcheck/wiki/SC1029)

