## Couldn't find end token `EOF' in the here document.

### Problematic code:

```sh
cat << EOF
  Hello World
```

### Correct code:

```sh
cat << EOF
  Hello World
EOF
```
### Rationale:

The `<<` here document (aka heredoc) was not properly terminated. The terminating token needs to be on a separate line without indenting (or indented with tabs only when using `<<-`).

Note that you can not put here documents in one liners. For such use cases, use a `<<<` here string:

    cat << EOF  hello world  EOF   # Wrong: data and terminator can not be on the same line
    cat <<< "hello world"          # Correct

### Exceptions:

None

### Related resources:

* Help by adding links to BashFAQ, StackOverflow, man pages, POSIX, etc!
[Source](https://github.com/koalaman/shellcheck/wiki/SC1044)

