## Not following: (error message here)

Reasons include: file not found, no permissions, not included on the command line, not allowing `shellcheck` to follow files with `-x`, etc.

### Problematic code:

```sh
source somefile
```

### Correct code:

In case you have access to the file, e.g. if it is included in your source code repository:

```sh
# shellcheck source=somefile
source somefile
```

In case you do not have access to the file:

```sh
# shellcheck disable=SC1091
source somefile
```

### Rationale:

ShellCheck, for whichever reason, is not able to access the source file.

This could be because you did not include it on the command line, did not use `shellcheck -x` to allow following other files, don't have permissions or a variety of other problems.

Feel free to ignore the error with a [[directive]].

### Exceptions:

If you're fine with it, ignore the message with a [[directive]].

[Source](https://github.com/koalaman/shellcheck/wiki/SC1091)

