# Note that unlike globs, o* here matches 'ooo' but not 'oscar'
### Problematic code:

```sh
grep 'foo*'
```

when wanting to match `food` and `foosball`, but not `mofo` or `keyfob`.

### Correct code:

```sh
grep '^foo'
```

### Rationale:

As a glob, `foo*` means "Any string starting with foo", e.g. `food` and `foosball`.

As a regular expression, "foo*" means "f followed by 1 or more o's, anywhere", e.g. "mofo" or "keyfob".

This construct is way more common as a glob than as a regex, so ShellCheck notifies you about it.

### Exceptions

If you're aware of the above, you can ignore this message. If you'd like shellcheck to be quiet, use a [[directive]] or `'fo[o]*'`.

[Source](https://github.com/koalaman/shellcheck/wiki/SC2022)

