## This is a literal string. To run as a command, use $(..) instead of '..' .

### Problematic code:

```sh
for i in 'seq 1 10'
do
  echo "$i"
done
```

### Correct code:

```sh
for i in $(seq 1 10)
do
  echo "$i"
done
```

### Rationale:

The intent was to run the code in the single quotes. This would have worked with slanted backticks, `` `..` ``, but here the very similar looking single quotes `'..'` were used, resulting in a string literal instead of command output.

This is one of the many problems with backticks, so it's better to use `$(..)` to expand commands.

### Exceptions:

None.

[Source](https://github.com/koalaman/shellcheck/wiki/SC2041)

