## Use "$@" (with quotes) to prevent whitespace problems.

### Problematic code:

```sh
cp $* ~/dir
```

### Correct code:

```sh
cp "$@" ~/dir
```

### Rationale:

`$*`, unquoted, is subject to word splitting and globbing.

Let's say you have three arguments: `baz`, `foo bar` and `*`

`"$@"` will expand into exactly that: `baz`, `foo bar` and `*`

`$*` will expand into multiple other arguments: `baz`, `foo`, `bar`, `file.txt` and `otherfile.jpg`

Since the latter is rarely expected or desired, ShellCheck warns about it.

### Exceptions

None.

[Source](https://github.com/koalaman/shellcheck/wiki/SC2048)

