## This expression is constant. Did you forget the `$` on a variable?
### Problematic code:

```sh
if [ myvar = "test" ]
then
  echo "Test mode"
fi
```

### Correct code:

```sh
if [ "$myvar" = "test" ]
then
  echo "Test mode"
fi
```
### Rationale:

ShellCheck has found a `[ .. ]` or `[[ .. ]]` comparison that only involves literal strings. The intention was probably to check a variable or command output instead.

This is usually due to missing `$` or bad quoting:

    if [[ "myvar" = "test" ]]             # always false because myvar is a literal string
    if [[ "$myvar" = "test" ]]            # correctly compares a variable

    if [ 'grep -c foo bar' -ge 10 ]       # always false because grep doesn't run
    if [ "$(grep -c foo bar)" -ge 10 ]    # correctly checks grep output

### Exceptions:

None
[Source](https://github.com/koalaman/shellcheck/wiki/SC2050)

