# Quote parameters to tr to prevent glob expansion.

### Problematic code:

```sh
tr -cd [:digit:]
```

### Correct code:

```sh
tr -cd '[:digit:]'
```

### Rationale:

From the shell's point of view, unquoted `[:digit:]` is a glob equivalent to `[dgit:]` that matches any single character filename from the group, such as `d` or `t`, in the current directory. 

If someone starts learning D and creates a directory named `d` to hold the source code, the glob will be expanded and the script will end up executing `tr -cd d` instead, which is clearly unintended.

Quoting the argument prevents this, and will pass it correctly as the literal string `[:digit:]` no matter which files exist in the current directory.

### Exceptions

None

[Source](https://github.com/koalaman/shellcheck/wiki/SC2060)

