## Double quote array expansions to avoid re-splitting elements.

### Problematic code:

```sh
cp $@ ~/dir
```

### Correct code:

```sh
cp "$@" ~/dir
```

### Rationale:

Double quotes around `$@` (and similarly, `${array[@]}`) prevents globbing and word splitting of individual elements, while still expanding to multiple separate arguments.

Let's say you have three arguments: `baz`, `foo bar` and `*`

`"$@"` will expand into exactly that: `baz`, `foo bar` and `*`

`$@` will expand into multiple other arguments: `baz`, `foo`, `bar`, `file.txt` and `otherfile.jpg`

Since the latter is rarely expected or desired, ShellCheck warns about it.

### Exceptions

When you want globbing of individual elements.

[Source](https://github.com/koalaman/shellcheck/wiki/SC2068)

