## To redirect stdout+stderr, 2>&1 must be last (or use '{ cmd > file; } 2>&1' to clarify).

### Problematic code:

```sh
firefox 2>&1 > /dev/null
```

### Correct code:

```sh
firefox > /dev/null 2>&1
```

### Rationale:

When it comes to redirection, order matters.

The problematic code means "Point stderr to where stdout is currently pointing (the terminal). Then point stdout to /dev/null".

The correct code means "Point stdout to /dev/null. Then point stderr to where stdout is currently pointing (/dev/null)".

In other words, the problematic code hides stdout and shows stderr. The correct code hides both stderr and stdout, which is usually the intention.

### Exceptions

If you actually do want to redirect stdout to a file, and then turn stderr into the new stdout, you can make this more explicit with braces:

    { firefox > /dev/null; } 2>&1

Also note that this warning does not trigger when output is piped or captured.

### Related resources:

* [Bash Pitfalls: somecmd 2>&1 >>logfile](https://mywiki.wooledge.org/BashPitfalls#pf43)
* [BashFaq: Tell me all about 2>&1 -- what's the difference between 2>&1 >foo and >foo 2>&1, and when do I use which?](https://mywiki.wooledge.org/BashFAQ/055)

[Source](https://github.com/koalaman/shellcheck/wiki/SC2069)

