## Remove '$' or use '_=$((expr))' to avoid executing output.

### Problematic code:

```sh
i=4
$(( i++ ))
```

### Correct code:

Bash, Ksh:

```sh
i=4
(( i++ ))
```

POSIX (assuming `++` is supported):

```sh
i=4
_=$(( i++ ))
```

Alternative POSIX version that does not preserve the exit code:

```sh
: $(( i++ ))
```

### Rationale:

`$((..))` expands to a number. If it's the only word on the line, the shell will try to execute this number as a command name:

```sh
$ i=4
$ $(( i++ ))
4: command not found
$ echo $i
5
```

To avoid trying to execute the number as a command name, use one of the methods mentioned:

```sh
$ i=4
$ _=$(( i++ ))
$ echo $i
5
```

### Exceptions:

None.

[Source](https://github.com/koalaman/shellcheck/wiki/SC2084)

