## Tilde does not expand in quotes. Use $HOME.

### Problematic code:

```sh
rm "~/Desktop/$filename"
```

### Correct code:

```sh
rm "$HOME/Desktop/$filename"
```

### Rationale:

Tilde does not expand to the user's home directory when it's single or double quoted. Use double quotes and `$HOME` instead.

Alternatively, the `~/` can be left unquoted, as in `rm ~/"Desktop/$filename"`.

### Exceptions

If you don't want the tilde to be expanded, you can ignore this message.

[Source](https://github.com/koalaman/shellcheck/wiki/SC2088)

