## On most OS, shebangs can only specify a single parameter.

### Problematic code:

```sh
#!/usr/bin/env bash -x
```

### Correct code:

```sh
#!/usr/bin/env bash
set -x
```

### Rationale:

Most operating systems, including POSIX, Linux and FreeBSD, allow only a single parameter in the shebang. The example is equivalent to calling `env 'bash -x'` instead of `env 'bash' '-x'`, and it will therefore fail.

The shebang should be rewritten to use at most one parameter. Shell options can instead be set in the body of the script.

### Exceptions

macOS X currently allows multiple words in the shebang. Scripts running on OSX exclusively can ignore this warning.
[Source](https://github.com/koalaman/shellcheck/wiki/SC2096)

