## Instead of '[ 1 ]', use 'true'.

### Problematic code:

```sh
while [ 1 ]
do
  echo "infinite loop"
done
```

### Correct code:

```sh
while true
do
  echo "infinite loop"
done
```

### Rationale:

This is a stylistic suggestion to use `true` instead of `[ 1 ]`.

`[ 1 ]` seems to suggest that the value "1" is somehow relevant to the statement. This is not the case: it doesn't matter. You can replace it with `[ 0 ]` or `[ wombat ]`, and it will still always be true.

If you instead use `true`, the value is actually considered and can be inverted by replacing with `false`.

On bash, you can also use `(( 1 ))`, which evaluates to true much like in C. `(( 0 ))` is similarly false.

### Exceptions:

None.

[Source](https://github.com/koalaman/shellcheck/wiki/SC2161)

