## 'time' is undefined for compound commands, time sh -c instead.

### Problematic code:

```sh
time for i in *.bmp; do convert "$i" "$i.png"; done
```

### Correct code:

```sh
time sh -c 'for i in *.bmp; do convert "$i" "$i.png"; done'
```
### Rationale:

`time` is only defined for Simple Commands [by POSIX](http://pubs.opengroup.org/onlinepubs/9699919799/utilities/time.html). Timing loops, command groups and similar is not.

### Exceptions:

None. If you use a shell that supports this (e.g. bash, ksh), specify this shell in the shebang.
[Source](https://github.com/koalaman/shellcheck/wiki/SC2177)

