## Bash does not support multidimensional arrays. Use 1D or associative arrays.

### Problematic code:

```sh
foo[1][2]=bar
echo "${foo[1][2]}"
```

### Correct code:

In bash4, consider using associative arrays:
```sh
declare -A foo
foo[1,2]=bar
echo "${foo[1,2]}"
```

Otherwise, do your own index arithmetic:
```sh
size=10
foo[1*size+2]=bar
echo "${foo[1*size+2]}"
```

### Rationale:

Bash does not support multidimensional arrays. Rewrite it to use 1D arrays. Associative arrays map arbitrary strings to values, and are therefore useful since you can construct keys like `"1,2,3"` or `"val1;val2;val3"` to index them.

### Exceptions:

None.
[Source](https://github.com/koalaman/shellcheck/wiki/SC2180)

