## This word is constant. Did you forget the $ on a variable?

### Problematic code:

```sh
case foo in
  bar) echo "Match"
esac
```

### Correct code:

```sh
case $foo in
  bar) echo "Match"
esac
```
### Rationale:

You are using a `case` statement to compare a literal word.

You most likely wanted to treat this word as a `$variable` or `$(command)` instead.

### Exceptions:

None
[Source](https://github.com/koalaman/shellcheck/wiki/SC2194)

