## Brace expansions don't work as operands in [ ]. Use a loop.

### Problematic code:

```sh
[ "$file" = index.{htm,html,php} ] && echo "This is the main file"

```

### Correct code:

```sh
for main in index.{htm,html,php}
do
  [ "$file" = "$main" ] && echo "This is the main file"
done
```

### Rationale:

Brace expansions in `[ ]` will expand to a sequence of words. Operators work on single words.

The problematic code is equivalent to `[ "$file" = index.htm index.html index.php ]`, which is invalid syntax. A typical error message is `bash: [: too many arguments` or `dash: somefile: unexpected operator`. 

Instead, use a `for` loop to iterate over values, and apply your condition to each.

### Exceptions:

None.
[Source](https://github.com/koalaman/shellcheck/wiki/SC2200)

