## This case is not specified by getopts.

### Problematic code:

```sh
while getopts "vr" n
do
  case "$n" in
    v) echo "Verbose" ;;
    r) echo "Recursive" ;;
    n) echo "Dry-run" ;;
    *) usage;;
  esac
done
```

### Correct code:

```sh
while getopts "vrn" n    # 'n' added here
do
  case "$n" in
    v) echo "Verbose" ;;
    r) echo "Recursive" ;;
    n) echo "Dry-run" ;;
    *) usage;;
  esac
done
```
### Rationale:

You have a `case` statement in a `while getopts` loop that matches a flag that hasn't been provided in the `getopts` option string.

Either add the flag to the options list, or delete the case statement.

### Exceptions:

None.
[Source](https://github.com/koalaman/shellcheck/wiki/SC2214)

