## This cp has no destination. Check the arguments.

### Problematic code:

```sh
cp "$file $dir"
```

### Correct code:

```sh
cp "$file" "$dir"
```
### Rationale:

ShellCheck found a `cp` command with a single parameter. This may be because the source and destination was accidentally merged into a single argument, or because the line was broken in an invalid way.

Fix the `cp` statement by correctly specifying both source and destination.

### Exceptions:

None
[Source](https://github.com/koalaman/shellcheck/wiki/SC2225)

