## This ! is not on a condition and skips errexit. Use `&& exit 1` instead, or make sure $? is checked.

### Problematic code:

```sh
set -e
! false
```

### Correct code:

```sh
set -e
! false && exit 1
```

### Rationale:

ShellCheck has found a command inverted with `!` that may have no effect. In particular, it does not appear as a condition in an `if` statement or `while` loop, or as the final command in a script or function.

The most common reason for this is thinking that it'll trigger `set -e` aka `errexit` if a command succeeds, as in the example. This is not the case: `!` will inhibit errexit both on success and failure of the inverted command.

Using `&& exit ` will instead exit when failure when the command succeeds.

### Exceptions:

ShellCheck will not detect cases where `$?` is implicitly or explicitly used to check the value afterwards:

```
set -e;
check_success() { [ $? -eq 0 ] || exit 1; }
! false; check_success
! true; check_success
```

In this case, you can [[ignore]] the warning.

### Related resources:

* StackOverflow: [Why do I need parenthesis In bash `set -e` and negated return code](https://stackoverflow.com/questions/39581150/why-do-i-need-parenthesis-in-bash-set-e-and-negated-return-code/39582012)
[Source](https://github.com/koalaman/shellcheck/wiki/SC2251)

