
Empty statements, i.e. `;`, are usually introduced by mistake, for example because:

- It was meant to be replaced by an actual statement, but this was forgotten.
- There was a typo which lead the semicolon to be doubled, i.e. `;;`.


## Noncompliant Code Example


    void DoSomething()
    {
        ; // Noncompliant - was used as a kind of TODO marker
    }
    
    void DoSomethingElse()
    {
        Console.WriteLine("Hello, world!");;  // Noncompliant - double ;
        // ...
        // Rarely, they are used on purpose as the body of a loop. It is a bad practice to
        // have side-effects outside of the loop:
        for (int i = 0; i &lt; 3; Console.WriteLine(i), i++); // Noncompliant
        // ...
    }


## Compliant Solution


    void DoSomething()
    {
    }
    
    void DoSomethingElse()
    {
        Console.WriteLine("Hello, world!");
        // ...
        for (int i = 0; i &lt; 3; i++)
        {
            Console.WriteLine(i);
         }
        // ...
    }


## See

- [CERT, MSC12-C.](https://www.securecoding.cert.org/confluence/x/NYA5) - Detect and remove code that has no effect or is never<br>  executed
- [CERT, MSC51-J.](https://www.securecoding.cert.org/confluence/x/7gCTAw) - Do not place a semicolon immediately following an if, for,<br>  or while condition
- [CERT, EXP15-C.](https://www.securecoding.cert.org/confluence/x/i4FtAg) - Do not place a semicolon on the same line as an if, for,<br>  or while statement

