
The `Obsolete` attribute can be applied with or without arguments, but marking something `Obsolete` without including advice<br>as to why it's obsolete or on what to use instead will lead maintainers to waste time trying to figure those things out - every single time the<br>warning is encountered.

## Noncompliant Code Example


    public class Car
    {
    
      [Obsolete]  // Noncompliant
      public void CrankEngine(int turnsOfCrank)
      { ... }
    }


## Compliant Solution


    public class Car
    {
    
      [Obsolete("Replaced by the automatic starter")]
      public void CrankEngine(int turnsOfCrank)
      { ... }
    }

