
Duplicated string literals make the process of refactoring error-prone, since you must be sure to update all occurrences.

On the other hand, constants can be referenced from many places, but only need to be updated in a single place.

## Noncompliant Code Example


    public class Foo
    {
        private string name = "foobar"; // Noncompliant
    
        public string DefaultName { get; } = "foobar"; // Noncompliant
    
        public Foo(string value = "foobar") // Noncompliant
        {
            var something = value ?? "foobar"; // Noncompliant
        }
    }


## Compliant Solution


    public class Foo
    {
        private const string Foobar = "foobar";
    
        private string name = Foobar;
    
        public string DefaultName { get; } = Foobar;
    
        public Foo(string value = Foobar)
        {
            var something = value ?? Foobar;
        }
    }


## Exceptions

The following are ignored:

- literals with fewer than 5 characters
- literals matching one of the parameter names
- literals used in attributes

