
This rule applies whenever an `if` statement is followed by one or more `else if` statements; the final `else if`<br>should be followed by an `else` statement.

The requirement for a final `else` statement is defensive programming.

The `else` statement should either take appropriate action or contain a suitable comment as to why no action is taken. This is<br>consistent with the requirement to have a final `default` clause in a `switch` statement.

## Noncompliant Code Example


    if (x == 0)
    {
        DoSomething();
    }
    else if (x == 1)
    {
        DoSomethingElse();
    }


## Compliant Solution


    if (x == 0)
    {
        DoSomething();
    }
    else if (x == 1)
    {
        DoSomethingElse();
    }
    else
    {
        throw new InvalidOperationException();
    }


## Exceptions

None

## See

- [CERT, MSC01-C.](https://www.securecoding.cert.org/confluence/x/YgE) - Strive for logical completeness
- [CERT, MSC57-J.](https://www.securecoding.cert.org/confluence/x/PQHRAw) - Strive for logical completeness

