
A static field in a generic type is not shared among instances of different closed constructed types, thus<br>`LengthLimitedSingletonCollection<int>.instances` and `LengthLimitedSingletonCollection<string>.instances` will<br>point to different objects, even though `instances` is seemingly shared among all `LengthLimitedSingletonCollection<>`<br>generic classes.

If you need to have a static field shared among instances with different generic arguments, define a non-generic base class to store your static<br>members, then set your generic type to inherit from the base class.

## Noncompliant Code Example


    public class LengthLimitedSingletonCollection&lt;T&gt; where T : new()
    {
      protected const int MaxAllowedLength = 5;
      protected static Dictionary&lt;Type, object&gt; instances = new Dictionary&lt;Type, object&gt;(); // Noncompliant
    
      public static T GetInstance()
      {
        object instance;
    
        if (!instances.TryGetValue(typeof(T), out instance))
        {
          if (instances.Count &gt;= MaxAllowedLength)
          {
            throw new Exception();
          }
          instance = new T();
          instances.Add(typeof(T), instance);
        }
        return (T)instance;
      }
    }


## Compliant Solution


    public class SingletonCollectionBase
    {
      protected static Dictionary&lt;Type, object&gt; instances = new Dictionary&lt;Type, object&gt;();
    }
    
    public class LengthLimitedSingletonCollection&lt;T&gt; : SingletonCollectionBase where T : new()
    {
      protected const int MaxAllowedLength = 5;
    
      public static T GetInstance()
      {
        object instance;
    
        if (!instances.TryGetValue(typeof(T), out instance))
        {
          if (instances.Count &gt;= MaxAllowedLength)
          {
            throw new Exception();
          }
          instance = new T();
          instances.Add(typeof(T), instance);
        }
        return (T)instance;
      }
    }


## Exceptions

If the static field or property uses a type parameter, then the developer is assumed to understand that the static member is not shared among the<br>closed constructed types.


    public class Cache&lt;T&gt;
    {
       private static Dictionary&lt;string, T&gt; CacheDictionary { get; set; } // Compliant
    }

