
Badly formed SQL is likely to cause errors at runtime.

This rule raises an issue when the spacing around SQL keywords appears to be missing.

## Noncompliant Code Example


    string select = "SELECT p.fname, p.lname, p.street1, p.street2, p.city, p.state, p.zip" +
            "FROM person p" +  // Noncompliant; concatenates to: p.zipFROM
            "WHERE p.id = @ID";  // Noncompliant; concatenates to: pWHERE


## Compliant Solution


    string select = "SELECT p.fname, p.lname, p.street1, p.street2, p.city, p.state, p.zip" +
        " FROM person p" +
        " WHERE p.id = @ID";

