
Because the `is` operator performs a cast if the object is not null, using `is` to check type and then casting the same<br>argument to that type, necessarily performs two casts. The same result can be achieved more efficiently with a single cast using `as`,<br>followed by a null-check.

## Noncompliant Code Example


    if (x is Fruit)  // Noncompliant
    {
      var f = (Fruit)x; // or x as Fruit
      // ...
    }


## Compliant Solution


    var f = x as Fruit;
    if (f != null)
    {
      // code
    }

