
In single-threaded environments, the use of `this` in constructors is normal, and expected. But in multi-threaded environments, it could<br>expose partially-constructed objects to other threads, and should be used with caution.

The classic example is a class with a `static` list of its instances. If the constructor stores `this` in the list, another<br>thread could access the object before it's fully-formed. Even when the storage of `this` is the last instruction in the constructor,<br>there's still a danger if the class is not `final`. In that case, the initialization of subclasses won't be complete before<br>`this` is exposed.

This rule raises an issue when `this` is assigned to any globally-visible object in a constructor, and when it is passed to the method<br>of another object in a constructor

## Noncompliant Code Example


    public class Monument
    {
      public static readonly List&lt;Monument&gt; ALL_MONUMENTS = new List&lt;Monument&gt;();
      // ...
    
      public Monument(string location, ...)
      {
        ALL_MONUMENTS.Add(this);  // Noncompliant; passed to a method of another object
    
        this.location = location;
        // ...
      }
    }


## Exceptions

This rule ignores instances of assigning `this` directly to a `static` field of the same class because that case is covered<br>by S3010.

## See

- [CERT, TSM01-J.](https://www.securecoding.cert.org/confluence/x/aAD1AQ) - Do not let the this reference escape during object<br>  construction
- [CERT, TSM03-J.](https://www.securecoding.cert.org/confluence/x/7ABQAg) - Do not publish partially initialized objects

