
It should be clear to a casual reader what code a test is testing and what results are expected. Unfortunately, that's not usually the case with<br>the `[ExpectedException]` attribute since an exception could be thrown from almost any line in the method.

This rule detects MSTest and NUnit `ExpectedException` attribute.

## Noncompliant Code Example


    [TestMethod]
    [ExpectedException(typeof(ArgumentNullException))]  // Noncompliant
    public void TestNullArg()
    {
      //...
    }


## Compliant Solution


    [TestMethod]
    public void TestNullArg()
    {
      bool callFailed = false;
      try
      {
        //...
      }
      catch (ArgumentNullException)
      {
        callFailed = true;
      }
      Assert.IsTrue(callFailed, "Expected call to MyMethod to fail with ArgumentNullException");
    }


## Exceptions

This rule ignores one-line test methods, since it is obvious in such methods where the exception is expected to be thrown.
