
`ToCharArray` can be omitted when the operation on the array could have been done directly on the string, such as when iterating over<br>the characters in a string, and when accessing a character in a string via an array index. In those cases, explicit `ToCharArray` calls<br>should be omitted.

## Noncompliant Code Example


    string str = "some string";
    foreach (var c in str.ToCharArray()) // Noncompliant
    {
      // ...
    }


## Compliant Solution


    string str = "some string";
    foreach (var c in str)
    {
      // ...
    }

