
It is important to inform the `ResourceManager` of the language used to display the resources of the neutral culture for an assembly.<br>This improves lookup performance for the first resource loaded.

This rule raises an issue when an assembly contains a `ResX`-based resource but does not have the<br>`System.Resources.NeutralResourcesLanguageAttribute` applied to it.

## Noncompliant Code Example


    using System;
    
    public class MyClass // Noncompliant
    {
       public static void Main()
       {
          string[] cultures = { "de-DE", "en-us", "fr-FR" };
          Random rnd = new Random();
          int index = rnd.Next(0, cultures.Length);
          Thread.CurrentThread.CurrentUICulture = CultureInfo.CreateSpecificCulture(cultures[index]);
    
          ResourceManager rm = new ResourceManager("MyResources" ,
                                                   typeof(MyClass).Assembly);
          string greeting = rm.GetString("Greeting");
    
          Console.Write("Enter your name: ");
          string name = Console.ReadLine();
          Console.WriteLine("{0} {1}!", greeting, name);
       }
    }


## Compliant Solution


    using System;
    
    [assembly:NeutralResourcesLanguageAttribute("en")]
    public class MyClass
    {
       public static void Main()
       {
          string[] cultures = { "de-DE", "en-us", "fr-FR" };
          Random rnd = new Random();
          int index = rnd.Next(0, cultures.Length);
          Thread.CurrentThread.CurrentUICulture = CultureInfo.CreateSpecificCulture(cultures[index]);
    
          ResourceManager rm = new ResourceManager("MyResources" ,
                                                   typeof(MyClass).Assembly);
          string greeting = rm.GetString("Greeting");
    
          Console.Write("Enter your name: ");
          string name = Console.ReadLine();
          Console.WriteLine("{0} {1}!", greeting, name);
       }
    }

