
Certain characters, once normalized to lowercase, cannot make a round trip. That is, they can not be converted from one locale to another and then<br>accurately restored to their original characters.

It is therefore strongly recommended to normalize characters and strings to uppercase instead.

## Noncompliant Code Example


    Thread.CurrentThread.CurrentCulture = new CultureInfo("tr-TR");
    var areStringEqual = "INTEGER".ToLower() == "integer"; // Noncompliant, the result is false as the ToLower will resolve to "ınteger"
    var areCharEqual = char.ToLower('I') == 'i'; // Noncompliant, the result is false as the ToLower will resolve to "ı"
    
    var incorrectRoundtrip = "İ".ToLowerInvariant().ToUpper() == "I".ToLowerInvariant().ToUpper(); // Noncompliant, because of the lower we lose the information about the correct uppercase character


## Compliant Solution


    Thread.CurrentThread.CurrentCulture = new CultureInfo("tr-TR");
    var areStringEqual = "ınteger".ToUpperInvariant() == "ıNTEGER";
    var areCharEqual = char.ToUpperInvariant('ı') == 'ı';
    var correctRoundtrip = "İ".ToUpperInvariant().ToLower() != "I".ToUpperInvariant().ToLower();


## See

- [Internationalization for Turkish](http://www.i18nguy.com/unicode/turkish-i18n.html)
- [How to correctly normalize<br>  strings](https://gingter.org/2018/07/10/how-to-correctly-normalize-strings-and-how-to-compare-them-in-net/)
- [Best Practices<br>  for Using Strings in .NET](https://docs.microsoft.com/en-us/dotnet/standard/base-types/best-practices-strings#recommendations-for-string-usage)

