
It makes little sense to create an extension method when it is possible to just add that method to the class itself.

This rule raises an issue when an extension is declared in the same namespace as the class it is extending.

## Noncompliant Code Example


    namespace MyLibrary
    {
        public class Foo
        {
            // ...
        }
    
        public static class MyExtensions
        {
            public static void Bar(this Foo a) // Noncompliant
            {
                // ...
            }
        }
    }


## Compliant Solution

Using separate namespace:


    namespace MyLibrary
    {
        public class Foo
        {
            // ...
        }
    }
    
    namespace Helpers
    {
        public static class MyExtensions
        {
            public void Bar()
            {
                // ...
            }
        }
    }


Merging the method in the class:


    namespace MyLibrary
    {
        public class Foo
        {
            // ...
            public void Bar()
            {
                // ...
            }
        }
    }

